
////////////////////////////////////////////////////////////
//	File:		"AnimInstance.cpp"
//	Author:		[JW] Jason Ware
//	Modified:	[JW] November 20, 2008
//	Purpose:	A class for animating frames for a sprite.
////////////////////////////////////////////////////////////

#include "AnimInstance.h"

#include "AnimationManager.h"

/* Data Members */

/* Constructors */

CAnimInstance::CAnimInstance()
{
	m_szSpriteFile	= "";
	m_szCurrentAnim = "";
	m_nCurrentFrame = -1;
	m_fFrameElapsed = -1.0f;
	m_pCurrentFrame = NULL;
}

/* Accessors */

/* Mutators */

/* Other Functions */

/* Destructor */

CAnimInstance::~CAnimInstance()
{

}

////////////////////////////////////////////////////////////
//	Function:	Update
//	Modified:	[JW] November 20, 2008
//	Purpose:	Updates the frames for a given animation.
////////////////////////////////////////////////////////////
void CAnimInstance::Update(float fElapsedTime)
{
	m_fFrameElapsed += fElapsedTime;

	if(m_pCurrentFrame->GetDuration() < m_fFrameElapsed)
	{
		if(NextFrame())
			m_fFrameElapsed = 0.0f;
	}
}

////////////////////////////////////////////////////////////
//	Function:	SetCurrentAnim
//	Modified:	[JW] November 20, 2008
//	Purpose:	Changes the current animation to render.
////////////////////////////////////////////////////////////
void CAnimInstance::SetCurrentAnim(string szCurrentAnim)
{
	if(CAnimationManager::GetInstance()->GetSpriteSheet(m_szSpriteFile)->GetAnimation(szCurrentAnim))
	{
		if(m_szCurrentAnim != szCurrentAnim)
		{
			m_nCurrentFrame = 0;
			m_fFrameElapsed = 0.0f;

			m_szCurrentAnim = szCurrentAnim;

			m_pCurrentFrame = CAnimationManager::GetInstance()->
				GetSpriteSheet(m_szSpriteFile)->
				GetAnimation(szCurrentAnim)->GetFrame(0);
		}
	}
}

////////////////////////////////////////////////////////////
//	Function:	CalcRect
//	Modified:	[JW] November 20, 2008
//	Purpose:	Determines the rect based on player position.
////////////////////////////////////////////////////////////
RECT CAnimInstance::CalcRect(RECT rRect, float fPosX, float fPosY, short sFlip, float fSize)
{
	RECT rNewRect;

	LONG lDiffX = (LONG)(m_pCurrentFrame->GetAnchorX() - rRect.left);
    LONG lDiffY = (LONG)(m_pCurrentFrame->GetAnchorY() - rRect.top);

	lDiffX *= (LONG)fSize*sFlip;
	lDiffY *= (LONG)fSize;

	LONG lWidth = rRect.right - rRect.left;
	LONG lHeight = rRect.bottom - rRect.top;

	rNewRect.left = (LONG)fPosX - lDiffX;
	rNewRect.top = (LONG)fPosY - lDiffY;
	rNewRect.right = (LONG)rNewRect.left + lWidth*(LONG)fSize;
	rNewRect.bottom = (LONG)rNewRect.top + lHeight*(LONG)fSize;

	return rNewRect;
}

////////////////////////////////////////////////////////////
//	Function:	ResetAnimation
//	Modified:	[JW] December 2, 2008
//	Purpose:	Resets the animation to the beginning.
////////////////////////////////////////////////////////////
void CAnimInstance::ResetCurrentAnim(void)
{
	m_nCurrentFrame = 0;
	m_fFrameElapsed = 0.0f;
	m_pCurrentFrame = CAnimationManager::GetInstance()->
		GetSpriteSheet(m_szSpriteFile)->
		GetAnimation(m_szCurrentAnim)->GetFrame(0);
}

/* Protected Functions */

/* Private Functions */

////////////////////////////////////////////////////////////
//	Function:	NextFrame
//	Modified:	[JW] November 20, 2008
//	Purpose:	Updates the new frame in the animation.
////////////////////////////////////////////////////////////
bool CAnimInstance::NextFrame()
{
	m_nCurrentFrame++;

	if(m_nCurrentFrame >= CAnimationManager::GetInstance()->GetSpriteSheet(m_szSpriteFile)->
		GetAnimation(m_szCurrentAnim)->GetFrameCount() &&
		CAnimationManager::GetInstance()->GetSpriteSheet(m_szSpriteFile)->
		GetAnimation(m_szCurrentAnim)->GetIsLooping())
	{
		m_nCurrentFrame = 0;
	}

	if(m_nCurrentFrame >= CAnimationManager::GetInstance()->GetSpriteSheet(m_szSpriteFile)->
		GetAnimation(m_szCurrentAnim)->GetFrameCount())
	{
		m_nCurrentFrame--;

		return false;
	}

	m_pCurrentFrame = CAnimationManager::GetInstance()->GetSpriteSheet(m_szSpriteFile)->
		GetAnimation(m_szCurrentAnim)->GetFrame(m_nCurrentFrame);

	return true;
}


